////////////////////////////////////////////////////////////////////////////////
// PIC USB Configuration							Create Date	2015/11/08
//			for PIC16 / PIC18						Last Update	2018/04/04
// file name :  usbconfig.h									Saka Softwares
// language  :  XC8 (v1.45)
// usbdev.cを使う時、アプリケーション固有の設定を行います。
// 製品にする場合はベンダーID、プロダクトIDを修正すしてください。
// 個人的に使う場合も上記IDか競合すると動作が怪しくなりますので注意してください。
////////////////////////////////////////////////////////////////////////////////
#ifndef _USB_CONFIG_H
#define	_USB_CONFIG_H

// USB Settings ////////////////////////////////////////////////////////////////
// 各エンドポイントのバッファサイズ
#define USB_USE_ENDPOINTS		2		// 使用するエンドポイント数
#define EP0_BUFF_SIZE			8		// EP0 バッファサイズ
#define EP1_OUT_BUFF_SIZE		64		// EP1 Out バッファサイズ
#define EP1_IN_BUFF_SIZE		64		// EP1 In バッファサイズ

// pic16f145x_Familyにて全てのバッファが80バイト以内に収まらない場合は、
// 直接EPxバッファアドレスを指定します。
#if defined(__16F1454) || defined(__16F1455) || defined(__16F1459) ||\
	  defined(__16LF1454) || defined(__16LF1455) || defined(__16LF1459)
	#define EP1_OUT_BUFF_ADDR	0x2050	// EP1Out Buffer Address
	#define EP1_IN_BUFF_ADDR	0x20A0	// EP1In Buffer Address
//	#define EP2_OUT_BUFF_ADDR	0x20F0	// EP2Out Buffer Address
//	#define EP2_IN_BUFF_ADDR	0x2140	// EP2In Buffer Address
//	#define EP3_OUT_BUFF_ADDR	0x2190	// EP2Out Buffer Address
//	#define EP3_IN_BUFF_ADDR	0x21E0	// EP2In Buffer Address
#endif

// 各ID/リリース番号
#define MY_VID					0x04D8	// ベンダーID	(Microchip)
#define MY_PID					0x003F	// プロダクトID	(Custom HID device demo)
#define MY_RLS					0x0002	// BCD表現の製品リリース番号

// 電源/構成設定
#define	POW_DEFAULT				0x80	// Default Value (Bit 7 is set)
#define POW_SELF				0x40	// Self-powered (Supports if set)
#define POW_RWU					0x20	// Remote Wakeup (Supports if set)
// 上記を組み合わせて設定値を作る
#define CFG_ATTRIBUTES			POW_DEFAULT
#define	CFG_BUSCURRENT			50		// 最大バス消費電流量 (2mA単位)

// Hardware Settings for Board /////////////////////////////////////////////////
// SOFのカウンタを使用する設定 (使用しない場合はコメントアウトしてください)
//#define ENSBLE_SOF_COUNTER

// バスパワー検出ピンの設定 (使用する場合下記を書き換えてください)
//#define USE_SELF_POWER_SENSE_IO
#if defined(USE_USB_BUS_SENSE_IO)
	#define tris_usb_bus_sense()	TRISxbits.TRISxx = 1	// 入力設定
	#define usb_bus_sense			PORTxbits.Rxx
#endif

// セルフパワー検出ピンの設定 (使用する場合下記を書き換えてください)
//#define USE_USB_BUS_SENSE_IO
#if defined(USE_SELF_POWER_SENSE_IO)
	#define tris_self_power()		TRISxbits.TRISxx = 1	// 入力設定
	#define self_power				PORTxbits.Rxx
#endif

////////////////////////////////////////////////////////////////////////////////
// USBのステータスででLEDを点滅させるか (main処理)
#define ENABLE_USB_LED_BLINK_STATUS

#endif	//_USB_CONFIG_H

// Descriptor //////////////////////////////////////////////////////////////////
// 使用するディスクリプタを選択
#include "usbdesc_Custom.h"			// HID Custom
//#include "usbdesc_Keyboard.h"		// HID Keyboard
//#include "usbdesc_Mouse.h"		// HID Mouse

// End of usbconfig.k //////////////////////////////////////////////////////////
